#!/bin/bash

echo "Start collecting..."
log_dir="$HOME"/.GlobalProtect
global_log_dir=/opt/paloaltonetworks/globalprotect
tmpdir="$HOME"/.gp1234
[ ! -d "$tmpdir" ] && mkdir -p "$tmpdir"

echo "collecting network info..."
/bin/ss -t -u -a > "$tmpdir"/NetStat.txt
/sbin/ip route > "$tmpdir"/RoutePrint.txt
/sbin/ip -6 route >> "$tmpdir"/RoutePrint.txt
/sbin/ip address > "$tmpdir"/IfConfig.txt
/sbin/ip -6 address >> "$tmpdir"/IfConfig.txt
nmcli dev show > "$tmpdir"/networkinfo.txt

echo "collecting machine info..."
/usr/bin/w > "$tmpdir"/MachineState.txt
/bin/df -k >> "$tmpdir"/MachineState.txt
/bin/ps axu >> "$tmpdir"/MachineState.txt
/sbin/sysctl -a >> "$tmpdir"/MachineState.txt
ping -t 4 -c 3 www.google.com 2>> "$tmpdir"/MachineState.txt >> "$tmpdir"/MachineState.txt
ping -t 4 -c 3 www.paloaltonetworks.com 2>> "$tmpdir"/MachineState.txt >> "$tmpdir"/MachineState.txt
/usr/bin/top -S -n 1 -b > "$tmpdir"/Top.txt

echo "copying files... "
cp -f "${log_dir}"/PanGPI.log "$tmpdir"/PanGPI.log
cp -f "${log_dir}"/PanGPI.log.old "$tmpdir"/PanGPI.log.old
cp -f "${log_dir}"/PanGPA.log "$tmpdir"/PanGPA.log
cp -f "${log_dir}"/PanGPA.log.old "$tmpdir"/PanGPA.log.old
cp -f "${global_log_dir}"/install.log "$tmpdir"/install.log
cp -f "${global_log_dir}"/PanGPS.log "$tmpdir"/PanGPS.log
cp -f "${global_log_dir}"/PanGPS.log.old "$tmpdir"/PanGPS.log.old
cp -f /var/log/syslog "$tmpdir"/
#cp -f /var/crash/*globalprotect* "$tmpdir"/

echo "generating final result file..."
cd "$tmpdir"
tar cvfz "${log_dir}"/Collect.tgz * > /dev/null 2>&1
cd "$HOME"
\rm -rf "$tmpdir"
echo "The support file is saved to ${log_dir}/Collect.tgz"
